DELIMITER //
CREATE PROCEDURE GenerateBillingID(IN inputYear INT)
BEGIN
    DECLARE currentYear INT;
    DECLARE currentIncrement INT;
    DECLARE newBillingID VARCHAR(12);
    -- Get the last two digits of the current year
    SELECT SUBSTRING(YEAR(CURDATE()), 3) INTO currentYear;

    -- Get the current incremented number from the latest billing ID
    SELECT CAST(SUBSTRING(MAX(bill_id), 5) AS UNSIGNED) INTO currentIncrement
    FROM billing_table
    WHERE SUBSTRING(bill_id, 3, 2) = currentYear;
    -- Check if the given year is greater than the available year
    IF inputYear > currentYear THEN
        -- Generate a new billing ID with incremented number reset to '000001'
        SET newBillingID = CONCAT('AA', LPAD(inputYear, 2, '0'), LPAD(1, 6, '0'));
        -- Update the billing ID in the billing_table
        -- Assuming 'billing_table' is the name of your table
        UPDATE billing_table
        SET bill_id = newBillingID
        WHERE SUBSTRING(bill_id, 3, 2) = currentYear;
        -- Output the new billing ID
        SELECT newBillingID AS generatedBillingID;
    ELSE
        -- Output a message indicating that the given year is not greater than the available year
        SELECT 'Given year is not greater than the available year' AS message;
    END IF;
END //

DELIMITER ;